<?php
// config.php
session_start();

// Include autoloader
require_once 'autoload.php';

class Config {
    const DB_HOST = 'localhost';
    const DB_NAME = 'wandepay_save';
    const DB_USER = 'wandepay_lusayo';
    const DB_PASS = '@Gloriambowe1996';
    
    // Contabo API endpoints
    const CONTABO_AUTH_URL = 'https://auth.contabo.com/auth/realms/contabo/protocol/openid-connect/token';
    const CONTABO_API_BASE = 'https://api.contabo.com/v1';
    
    // Base URL for store redirection
    const BASE_URL = 'http://localhost/contabo'; // Change to your domain
}

// Database connection
function getDB() {
    try {
        $pdo = new PDO(
            "mysql:host=" . Config::DB_HOST . ";dbname=" . Config::DB_NAME,
            Config::DB_USER,
            Config::DB_PASS
        );
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    } catch(PDOException $e) {
        die("Connection failed: " . $e->getMessage());
    }
}

// Authentication helper functions
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function isAdmin() {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';
}

function isUser() {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'user';
}

function isCustomer() {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'customer';
}

function redirectIfNotLoggedIn() {
    if (!isLoggedIn()) {
        header("Location: login.php");
        exit;
    }
}

function redirectIfNotAdmin() {
    if (!isAdmin()) {
        header("Location: user_vps.php");
        exit;
    }
}

function redirectIfNotUser() {
    if (!isUser()) {
        header("Location: customer_dashboard.php");
        exit;
    }
}

function redirectIfNotCustomer() {
    if (!isCustomer()) {
        header("Location: login.php");
        exit;
    }
}

// Store domain detection
function detectStoreDomain() {
    $domain = $_SERVER['HTTP_HOST'] ?? '';
    
    // Log domain access for tracking
    if ($domain && $domain !== 'localhost') {
        try {
            $db = getDB();
            $stmt = $db->prepare("INSERT INTO domain_requests (domain) VALUES (?)");
            $stmt->execute([$domain]);
        } catch (Exception $e) {
            // Silently fail domain logging
        }
    }
    
    return $domain;
}

// Get store user by domain
function getStoreUserByDomain($domain) {
    try {
        $db = getDB();
        $stmt = $db->prepare("
            SELECT u.*, uss.store_name, uss.store_domain 
            FROM users u 
            INNER JOIN user_store_settings uss ON u.id = uss.user_id 
            WHERE uss.store_domain = ? AND u.role = 'user'
        ");
        $stmt->execute([$domain]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        return null;
    }
}
?>