<?php
// dashboard.php
require_once 'config.php';
require_once 'contabo_api.php';

redirectIfNotLoggedIn();

// Get user's VPS instances
$db = getDB();
$stmt = $db->prepare("
    SELECT vi.* FROM vps_instances vi 
    WHERE vi.assigned_to = ? 
    ORDER BY vi.created_date DESC
");
$stmt->execute([$_SESSION['user_id']]);
$userInstances = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get user info
$userStmt = $db->prepare("SELECT username, email, created_at FROM users WHERE id = ?");
$userStmt->execute([$_SESSION['user_id']]);
$userInfo = $userStmt->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Dashboard</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; }
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px; }
        .stats { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 30px; }
        .stat-card { background: #f8f9fa; padding: 20px; border-radius: 8px; text-align: center; }
        .stat-number { font-size: 2rem; font-weight: bold; color: #007bff; }
        .instances-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px; }
        .instance-card { border: 1px solid #ddd; padding: 15px; border-radius: 8px; }
        .btn { display: inline-block; padding: 8px 16px; background: #007bff; color: white; text-decoration: none; border-radius: 4px; }
        .nav-links { margin-bottom: 20px; }
        .nav-links a { margin-right: 15px; text-decoration: none; color: #007bff; }
    </style>
</head>
<body>
    <div class="container">
        <div class="nav-links">
            <a href="vps_packages.php">Order VPS</a>
            <a href="logout.php">Logout</a>
        </div>
        
        <div class="header">
            <h1>Welcome, <?php echo htmlspecialchars($userInfo['username']); ?></h1>
            <a href="vps_packages.php" class="btn">Order New VPS</a>
        </div>
        
        <div class="stats">
            <div class="stat-card">
                <div class="stat-number"><?php echo count($userInstances); ?></div>
                <div>VPS Instances</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo date('M j, Y', strtotime($userInfo['created_at'])); ?></div>
                <div>Member Since</div>
            </div>
        </div>
        
        <h2>Your VPS Instances</h2>
        
        <?php if (empty($userInstances)): ?>
            <p>You don't have any VPS instances yet. <a href="vps_packages.php">Order your first VPS</a></p>
        <?php else: ?>
            <div class="instances-grid">
                <?php foreach ($userInstances as $instance): ?>
                    <div class="instance-card">
                        <h3><?php echo htmlspecialchars($instance['name']); ?></h3>
                        <p><strong>ID:</strong> <?php echo htmlspecialchars($instance['instance_id']); ?></p>
                        <p><strong>Status:</strong> 
                            <span style="color: <?php echo $instance['status'] === 'running' ? '#28a745' : '#dc3545'; ?>">
                                <?php echo htmlspecialchars($instance['status']); ?>
                            </span>
                        </p>
                        <p><strong>IP:</strong> <?php echo htmlspecialchars($instance['ip_address']); ?></p>
                        <p><strong>Region:</strong> <?php echo htmlspecialchars($instance['region']); ?></p>
                        <p><strong>Created:</strong> <?php echo date('M j, Y', strtotime($instance['created_date'])); ?></p>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>