<?php
// vps_packages.php
require_once 'config.php';
require_once 'contabo_api.php';

$message = '';
$error = '';

// Get VPS packages
$packages = ContaboAPI::getVpsPackages();

// Check if user is logged in
$isLoggedIn = isset($_SESSION['user_id']);

// Handle package selection
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['package_id'])) {
    if (!$isLoggedIn) {
        $_SESSION['redirect_after_login'] = 'vps_configure.php?package=' . $_POST['package_id'];
        header("Location: login.php");
        exit;
    }
    
    header("Location: vps_configure.php?package=" . $_POST['package_id']);
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>VPS Packages - Choose Your Plan</title>
    <style>
        :root {
            --primary: #007bff;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --info: #17a2b8;
            --secondary: #6c757d;
            --light: #f8f9fa;
            --dark: #343a40;
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
        }
        
        .header {
            text-align: center;
            color: white;
            margin-bottom: 40px;
        }
        
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 10px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }
        
        .header p {
            font-size: 1.2rem;
            opacity: 0.9;
        }
        
        .auth-buttons {
            position: absolute;
            top: 20px;
            right: 20px;
            display: flex;
            gap: 10px;
        }
        
        .btn {
            display: inline-block;
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
            text-align: center;
        }
        
        .btn-primary {
            background: var(--primary);
            color: white;
        }
        
        .btn-outline-light {
            background: transparent;
            color: white;
            border: 2px solid white;
        }
        
        .btn-success {
            background: var(--success);
            color: white;
        }
        
        .btn-lg {
            padding: 15px 30px;
            font-size: 1.1rem;
        }
        
        .packages-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 30px;
            margin-top: 30px;
        }
        
        .package-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .package-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.3);
        }
        
        .package-card.popular {
            border: 3px solid var(--warning);
            transform: scale(1.05);
        }
        
        .package-card.popular:hover {
            transform: scale(1.05) translateY(-10px);
        }
        
        .popular-badge {
            position: absolute;
            top: 20px;
            right: -30px;
            background: var(--warning);
            color: black;
            padding: 5px 40px;
            transform: rotate(45deg);
            font-weight: bold;
            font-size: 0.8rem;
        }
        
        .package-header {
            text-align: center;
            margin-bottom: 20px;
        }
        
        .package-name {
            font-size: 1.5rem;
            font-weight: bold;
            color: var(--dark);
            margin-bottom: 5px;
        }
        
        .package-description {
            color: var(--secondary);
            font-style: italic;
        }
        
        .package-price {
            text-align: center;
            margin-bottom: 25px;
        }
        
        .price-monthly {
            font-size: 2.5rem;
            font-weight: bold;
            color: var(--primary);
        }
        
        .price-original {
            font-size: 1.2rem;
            color: var(--secondary);
            text-decoration: line-through;
            margin-left: 10px;
        }
        
        .price-period {
            color: var(--secondary);
            font-size: 0.9rem;
        }
        
        .package-features {
            list-style: none;
            margin-bottom: 25px;
        }
        
        .package-features li {
            padding: 8px 0;
            border-bottom: 1px solid #f0f0f0;
            display: flex;
            align-items: center;
        }
        
        .package-features li:last-child {
            border-bottom: none;
        }
        
        .feature-icon {
            color: var(--success);
            margin-right: 10px;
            font-weight: bold;
        }
        
        .package-actions {
            text-align: center;
        }
        
        .login-prompt {
            background: rgba(255,255,255,0.1);
            backdrop-filter: blur(10px);
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            color: white;
            margin-top: 30px;
        }
        
        .feature-comparison {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-top: 50px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        .comparison-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        
        .comparison-table th,
        .comparison-table td {
            padding: 12px;
            text-align: center;
            border-bottom: 1px solid #f0f0f0;
        }
        
        .comparison-table th {
            background: var(--light);
            font-weight: 600;
        }
        
        .feature-name {
            text-align: left;
            font-weight: 500;
        }
        
        @media (max-width: 768px) {
            .packages-grid {
                grid-template-columns: 1fr;
            }
            
            .package-card.popular {
                transform: none;
            }
            
            .package-card.popular:hover {
                transform: translateY(-10px);
            }
            
            .auth-buttons {
                position: static;
                justify-content: center;
                margin-bottom: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="auth-buttons">
            <?php if ($isLoggedIn): ?>
                <span style="color: white; margin-right: 15px;">
                    Welcome, <?php echo htmlspecialchars($_SESSION['username']); ?>
                </span>
                <a href="dashboard.php" class="btn btn-outline-light">Dashboard</a>
                <a href="logout.php" class="btn btn-outline-light">Logout</a>
            <?php else: ?>
                <a href="login.php" class="btn btn-outline-light">Login</a>
                <a href="register.php" class="btn btn-primary">Register</a>
            <?php endif; ?>
        </div>
        
        <div class="header">
            <h1>Cloud VPS Packages</h1>
            <p>Choose the perfect VPS plan for your needs</p>
        </div>
        
        <?php if ($message): ?>
            <div style="background: var(--success); color: white; padding: 15px; border-radius: 8px; margin-bottom: 20px; text-align: center;">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>
        
        <?php if ($error): ?>
            <div style="background: var(--danger); color: white; padding: 15px; border-radius: 8px; margin-bottom: 20px; text-align: center;">
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>
        
        <div class="packages-grid">
            <?php foreach ($packages as $packageId => $package): ?>
                <div class="package-card <?php echo $packageId === 'V94' ? 'popular' : ''; ?>">
                    <?php if ($packageId === 'V94'): ?>
                        <div class="popular-badge">MOST POPULAR</div>
                    <?php endif; ?>
                    
                    <div class="package-header">
                        <div class="package-name"><?php echo htmlspecialchars($package['name']); ?></div>
                        <div class="package-description"><?php echo htmlspecialchars($package['description']); ?></div>
                    </div>
                    
                    <div class="package-price">
                        <span class="price-monthly">
                            <?php echo $package['currency'] . $package['price_monthly']; ?>
                        </span>
                        <span class="price-original">
                            <?php echo $package['currency'] . $package['price_original']; ?>
                        </span>
                        <div class="price-period">/ month</div>
                    </div>
                    
                    <ul class="package-features">
                        <li><span class="feature-icon">✓</span> <?php echo $package['cpu']; ?> vCPU Cores</li>
                        <li><span class="feature-icon">✓</span> <?php echo $package['ram']; ?> GB RAM</li>
                        <li><span class="feature-icon">✓</span> <?php echo $package['disk']; ?> GB <?php echo $package['disk_type']; ?></li>
                        <li><span class="feature-icon">✓</span> <?php echo $package['snapshots']; ?> Snapshot<?php echo $package['snapshots'] > 1 ? 's' : ''; ?></li>
                        <li><span class="feature-icon">✓</span> <?php echo $package['traffic']; ?> Traffic</li>
                        <li><span class="feature-icon">✓</span> Unlimited Incoming</li>
                        <?php if ($package['backup']): ?>
                            <li><span class="feature-icon">✓</span> Free Auto Backup</li>
                        <?php endif; ?>
                    </ul>
                    
                    <div class="package-actions">
                        <form method="POST">
                            <input type="hidden" name="package_id" value="<?php echo $packageId; ?>">
                            <button type="submit" class="btn btn-success btn-lg">
                                <?php echo $isLoggedIn ? 'Configure' : 'Order Now'; ?>
                            </button>
                        </form>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <?php if (!$isLoggedIn): ?>
            <div class="login-prompt">
                <h3>Ready to get started?</h3>
                <p>Please login or create an account to order your VPS</p>
                <div style="margin-top: 15px;">
                    <a href="login.php" class="btn btn-outline-light">Login</a>
                    <a href="register.php" class="btn btn-primary">Create Account</a>
                </div>
            </div>
        <?php endif; ?>
        
        <div class="feature-comparison">
            <h2 style="text-align: center; margin-bottom: 30px;">Feature Comparison</h2>
            <table class="comparison-table">
                <thead>
                    <tr>
                        <th>Feature</th>
                        <?php foreach (array_slice($packages, 0, 4) as $packageId => $package): ?>
                            <th><?php echo htmlspecialchars($package['name']); ?></th>
                        <?php endforeach; ?>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="feature-name">vCPU Cores</td>
                        <?php foreach (array_slice($packages, 0, 4) as $package): ?>
                            <td><?php echo $package['cpu']; ?></td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <td class="feature-name">RAM</td>
                        <?php foreach (array_slice($packages, 0, 4) as $package): ?>
                            <td><?php echo $package['ram']; ?> GB</td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <td class="feature-name">Storage</td>
                        <?php foreach (array_slice($packages, 0, 4) as $package): ?>
                            <td><?php echo $package['disk']; ?> GB <?php echo $package['disk_type']; ?></td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <td class="feature-name">Snapshots</td>
                        <?php foreach (array_slice($packages, 0, 4) as $package): ?>
                            <td><?php echo $package['snapshots']; ?></td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <td class="feature-name">Traffic</td>
                        <?php foreach (array_slice($packages, 0, 4) as $package): ?>
                            <td><?php echo $package['traffic']; ?></td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <td class="feature-name">Backup</td>
                        <?php foreach (array_slice($packages, 0, 4) as $package): ?>
                            <td><?php echo $package['backup'] ? '✓' : '✗'; ?></td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <td class="feature-name">Price/month</td>
                        <?php foreach (array_slice($packages, 0, 4) as $package): ?>
                            <td><strong><?php echo $package['currency'] . $package['price_monthly']; ?></strong></td>
                        <?php endforeach; ?>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>